/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.ntfy;

import com.ibm.hwmca.base.ntfy.NotificationConstants;
import com.ibm.hwmca.base.ntfy.NotificationMessageRes;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskMessage;
import com.ibm.ui.framework.ValueDescriptor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class MessageTemplateEditorPanelBean
extends PanelBean
implements NotificationConstants {
    private static final String TRACE_MASKT = "XNTYMTPT";
    private static final String TRACE_MASKF = "XNTYMTPF";
    private static final String TRACE_MASKD = "XNTYMTPD";
    private String m_sName;
    private String m_sDesc;
    private String m_sSampleMessageList;
    private transient ValueDescriptor[] m_cdSampleMessageList;
    private transient ItemDescriptor[][] m_idMsgTemplateTable;
    private transient ColumnDescriptor[] m_cdMsgTemplateTableStructure;
    private int[] m_iMsgTemplateTableSelection;
    private Map data;
    private static final int NUM_ROWS = 20;
    public static final String SAMPLE_MESSAGE_TEMPLATES = "SampleMessageTemplates";
    public static final String MSG_TEMPLATE_TABLE = "MsgTemplateTable";
    public static final String DATA_MAP_FIELD_NAME = "DataMapFieldName";
    public static final String DATA_MAP_FIELD_TYPE = "DataMapFieldType";
    public static final String DATA_MAP_FIELD_START = "DataMapFieldStart";
    public static final String DATA_MAP_FIELD_END = "DataMapFieldEnd";
    public static final String DATA_MAP_TEMPLATE_NAME = "DataMapTemplateName";
    public static final String DATA_MAP_TEMPLATE_DESC = "DataMapTemplateDesc";
    private static final String RES_NAME = "com.ibm.hwmca.base.ntfy.res.NotificationRes";

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> panelAction()");
        String command = event.getActionCommand();
        if (command == null || command.equals("CANCEL")) {
            command = this.getMountPrefix() + "CancelButton";
        }
        this.userTaskManager.storeAllElements();
        PanelTaskletRequest request = new PanelTaskletRequest(this.getClass().getName() + this.getMountPrefix());
        request.setData("CommandSource", "MessageTemplateEditorPanel");
        if (command.equals(this.getMountPrefix() + "OKButton") || command.equals(this.getMountPrefix() + "ApplyButton")) {
            if (command.equals(this.getMountPrefix() + "OKButton")) {
                request.setData("CommandName", "OKButton");
            } else {
                request.setData("CommandName", "ApplyButton");
            }
            String[][] fields = new String[20][4];
            ResourceBundle res = ResourceBundle.getBundle(RES_NAME);
            int i = 0;
            while (i < 20) {
                TaskMessage tm;
                int j = 0;
                while (j < 3) {
                    fields[i][j] = this.m_idMsgTemplateTable[i][j].getTitle();
                    ++j;
                }
                fields[i][3] = this.m_idMsgTemplateTable[i][3].getTitle().equals(res.getString("MessageTemplateEditorPanel.StringItem.VALUE")) ? "TypeString" : "TypeInteger";
                int start = -1;
                int end = -1;
                try {
                    start = Integer.parseInt(fields[i][1]);
                }
                catch (NumberFormatException nfe) {
                    if (fields[i][1].trim().equals("")) {
                        start = 0;
                    }
                    TaskMessage tm2 = new TaskMessage(this.userTaskManager, MessageFormat.format(new NotificationMessageRes().getString("ntfy.error.numberformatproblem"), fields[i][1], nfe.getMessage()), 1);
                    tm2.invoke();
                    return;
                }
                try {
                    end = Integer.parseInt(fields[i][2]);
                }
                catch (NumberFormatException nfe) {
                    if (fields[i][2].trim().equals("*")) {
                        fields[i][2] = fields[i][2].trim();
                        end = Integer.MAX_VALUE;
                    }
                    if (fields[i][2].trim().equals("")) {
                        end = Integer.MAX_VALUE;
                    }
                    TaskMessage tm3 = new TaskMessage(this.userTaskManager, MessageFormat.format(new NotificationMessageRes().getString("ntfy.error.numberformatproblem"), fields[i][2], nfe.getMessage()), 1);
                    tm3.invoke();
                    return;
                }
                if (start < 0) {
                    tm = new TaskMessage(this.userTaskManager, MessageFormat.format(new NotificationMessageRes().getString("ntfy.error.numberlessthanzeroproblem"), fields[i][1]), 1);
                    tm.invoke();
                    return;
                }
                if (end <= start) {
                    tm = new TaskMessage(this.userTaskManager, MessageFormat.format(new NotificationMessageRes().getString("ntfy.error.numberendbeforestartproblem"), fields[i][2]), 1);
                    tm.invoke();
                    return;
                }
                ++i;
            }
            this.m_sName = this.m_sName.trim();
            request.setData(DATA_MAP_TEMPLATE_NAME, this.m_sName);
            request.setData(DATA_MAP_TEMPLATE_DESC, this.m_sDesc);
            request.setData(MSG_TEMPLATE_TABLE, fields);
        } else if (command.equals(this.getMountPrefix() + "CancelButton")) {
            request.setData("CommandName", "CancelButton");
        }
        if ((request.getData("CommandName").equals("OKButton") || request.getData("CommandName").equals("ApplyButton")) && (this.m_sName == null || this.m_sName.trim().equals(""))) {
            TaskMessage tm = new TaskMessage(this.userTaskManager, new NotificationMessageRes().getString("ntfy.error.blankname"), 1);
            tm.invoke();
            this.userTaskManager.setValue(this.getMountPrefix() + "Name", "");
            this.m_sName = "";
        } else {
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "<> save()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        String[] sampleMessages = (String[])this.data.get(SAMPLE_MESSAGE_TEMPLATES);
        if (sampleMessages != null && sampleMessages.length > 0) {
            this.m_cdSampleMessageList = new ValueDescriptor[sampleMessages.length];
            int i = 0;
            while (i < sampleMessages.length) {
                this.m_cdSampleMessageList[i] = new ValueDescriptor(this.getMountPrefix() + SAMPLE_MESSAGE_TEMPLATES + i, sampleMessages[i]);
                ++i;
            }
            this.m_sSampleMessageList = sampleMessages[0];
        }
        int tableRows = 0;
        ResourceBundle res = ResourceBundle.getBundle(RES_NAME);
        int i = 0;
        String[][] table = (String[][])this.data.get(MSG_TEMPLATE_TABLE);
        if (table != null) {
            tableRows = 0;
            while (tableRows < table.length) {
                if (table[tableRows] != null && table[tableRows][0] != null && table[tableRows][1] != null && table[tableRows][2] != null && table[tableRows][3] != null) {
                    this.m_idMsgTemplateTable[i][0] = new ItemDescriptor(this.getMountPrefix() + MSG_TEMPLATE_TABLE + "_a_" + tableRows, table[tableRows][0]);
                    this.m_idMsgTemplateTable[i][1] = new ItemDescriptor(this.getMountPrefix() + MSG_TEMPLATE_TABLE + "_b_" + tableRows, table[tableRows][1]);
                    this.m_idMsgTemplateTable[i][2] = new ItemDescriptor(this.getMountPrefix() + MSG_TEMPLATE_TABLE + "_c_" + tableRows, table[tableRows][2]);
                    this.m_idMsgTemplateTable[i][3] = table[tableRows][3].equals("TypeString") ? new ItemDescriptor(this.getMountPrefix() + MSG_TEMPLATE_TABLE + "_d_" + tableRows, res.getString("MessageTemplateEditorPanel.StringItem.VALUE")) : new ItemDescriptor(this.getMountPrefix() + MSG_TEMPLATE_TABLE + "_d_" + tableRows, res.getString("MessageTemplateEditorPanel.NumberItem.VALUE"));
                    ++i;
                }
                ++tableRows;
            }
        }
        while (i < 20) {
            Trace.trace(TRACE_MASKF, "adding a buffer row");
            this.m_idMsgTemplateTable[i][0] = new ItemDescriptor(this.getMountPrefix() + MSG_TEMPLATE_TABLE + "_a_" + tableRows, "");
            this.m_idMsgTemplateTable[i][1] = new ItemDescriptor(this.getMountPrefix() + MSG_TEMPLATE_TABLE + "_b_" + tableRows, "");
            this.m_idMsgTemplateTable[i][2] = new ItemDescriptor(this.getMountPrefix() + MSG_TEMPLATE_TABLE + "_c_" + tableRows, "");
            this.m_idMsgTemplateTable[i][3] = new ItemDescriptor(this.getMountPrefix() + MSG_TEMPLATE_TABLE + "_d_" + tableRows, "");
            ++i;
        }
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    public void load() {
        this.m_sSampleMessageList = "";
        this.m_cdSampleMessageList = new ValueDescriptor[0];
        this.m_idMsgTemplateTable = new ItemDescriptor[20][4];
        this.m_cdMsgTemplateTableStructure = new ColumnDescriptor[0];
        this.m_iMsgTemplateTableSelection = new int[0];
        if (this.data == null) {
            this.data = new HashMap();
        }
        this.m_sName = (String)this.data.get(DATA_MAP_TEMPLATE_NAME);
        this.m_sDesc = (String)this.data.get(DATA_MAP_TEMPLATE_DESC);
        if (this.m_sName == null) {
            this.m_sName = "";
        }
        if (this.m_sDesc == null) {
            this.m_sDesc = "";
        }
    }

    public void setData(Map data) {
        this.data = data;
    }

    public int getMsgTemplateTableRowCount() {
        return 20;
    }

    public ItemDescriptor[] getMsgTemplateTableRowAt(int index) {
        return this.m_idMsgTemplateTable[index];
    }

    public void setMsgTemplateTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idMsgTemplateTable[index] = items;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String s) throws IllegalUserDataException {
        this.m_sName = s;
    }

    public String getDesc() {
        return this.m_sDesc;
    }

    public void setDesc(String s) throws IllegalUserDataException {
        this.m_sDesc = s;
    }

    public String getSampleMessageList() {
        return this.m_sSampleMessageList;
    }

    public void setSampleMessageList(String s) throws IllegalUserDataException {
        this.m_sSampleMessageList = s;
    }

    public ValueDescriptor[] getSampleMessageListList() {
        return this.m_cdSampleMessageList;
    }

    public ColumnDescriptor[] getMsgTemplateTableRowStructure() {
        return this.m_cdMsgTemplateTableStructure;
    }

    public int getMsgTemplateTableRowStatus() {
        return 3;
    }

    public int[] getMsgTemplateTableSelection() {
        return this.m_iMsgTemplateTableSelection;
    }

    public void setMsgTemplateTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iMsgTemplateTableSelection = selected;
    }
}

